#{{uc_id}}.ue-container{
  width: 100%;
  display: flex;
  align-items: center;
}

/* Timeline Container */

#{{uc_id}} .ue-timeline {
  width:100%;
  margin: 0 auto;
  padding: 0 20px;
}

#{{uc_id}} .ue-item-image{
  overflow:hidden;
}

#{{uc_id}} .ue-item-image img{
  width:100%;
  height: 100%;
  transition:0.3s;
}

/* Card container */
#{{uc_id}} .ue-card {
  position: relative;
  display: flex;
}

#{{uc_id}} .ue-slno{
  border-radius: 50%;
  position: absolute;
  top: 50%;
  left: 0;
  transform: translate(-50%, -50%);
  display: grid;
  place-content: center;
}

/* setting padding based on even or odd */
{% if rtl == "false" %}
  #{{uc_id}} .ue-card:nth-child(odd) {
    padding: 30px 0 30px 30px;
  }
  #{{uc_id}} .ue-card:nth-child(even) {
    padding: 30px 30px 30px 0;
  }
  /* Global ::before */
  #{{uc_id}} .ue-card::before {
    content: "";
    position: absolute;
    width: 50%;
  }

  /* Setting the border of top, bottom, left */
  #{{uc_id}} .ue-card:nth-child(odd)::before {
    left: 0px;
    top: -{{curved_line_thickness_nounit}}px;
    bottom: -{{curved_line_thickness_nounit}}px;
    border-width: {{curved_line_thickness_nounit}}px 0 {{curved_line_thickness_nounit}}px {{curved_line_thickness_nounit}}px;
    border-radius: 20px 0 0 20px;
  }

  /* Setting the top and bottom to "-{{curved_line_thickness_nounit}}px" because earlier it was out of a pixel in mobile devices */
  @media only screen and (max-width: 400px) {
    #{{uc_id}} .ue-card:nth-child(odd)::before {
      top: -{{curved_line_thickness_nounit}}px;
      bottom: -{{curved_line_thickness_nounit}}px;
    }
  }

  /* Setting the border of top, bottom, right */
  #{{uc_id}} .ue-card:nth-child(even)::before {
    right: 0;
    top: 0;
    bottom: 0;
    border-width: {{curved_line_thickness_nounit}}px {{curved_line_thickness_nounit}}px {{curved_line_thickness_nounit}}px 0;
    border-radius: 0 20px 20px 0;
  }

  /* Removing the border if it is the first card */
  #{{uc_id}} .ue-card:first-child::before {
    border-top: 0;
    border-top-left-radius: 0;
  }

  /* Removing the border if it is the last card  and it's odd */
  #{{uc_id}} .ue-card:last-child:nth-child(odd)::before {
    border-bottom: 0;
    border-bottom-left-radius: 0;
  }

  /* Removing the border if it is the last card  and it's even */
  #{{uc_id}} .ue-card:last-child:nth-child(even)::before {
    border-bottom: 0;
    border-bottom-right-radius: 0;
  }

  /* Information about the timeline */
  #{{uc_id}} .ue-info {
    display: flex;
    border-radius: 10px;
    padding: 10px;
    width: 100%;
  }

  /* Title of the card */
  #{{uc_id}} .ue-title {
    position: relative;
  }

  /* Timeline dot  */

  /* text right if the card is even  */
  #{{uc_id}} .ue-card:nth-child(even) {
    text-align: right;
  }

  #{{uc_id}} .ue-card:nth-child(even) .ue-item-image{
    margin-left: auto;
  }

  #{{uc_id}} .ue-card:nth-child(even) .ue-info{
    padding-right: 20px;
    margin-left: auto;
  }

  #{{uc_id}} .ue-card:nth-child(odd) .ue-info{
    padding-left: 20px;
  }

  /* setting dot to the left if the card is odd */
  #{{uc_id}} .ue-card:nth-child(odd) > .ue-info > .ue-title::before {
    left: -45px;
  }

  #{{uc_id}} .ue-card:nth-child(even) > .ue-slno{
    right: 0%;
    left: auto;
    transform: translate(50%, -50%);
    margin-right:calc({{curved_line_thickness_nounit}}px/2);
  }

  #{{uc_id}} .ue-card:nth-child(odd) > .ue-slno{
    margin-left:calc({{curved_line_thickness_nounit}}px/2);;
  }

  #{{uc_id}} .ue-card:nth-child(1)::before{
    height: 50%;
    top: auto;
  }

  #{{uc_id}} .ue-card:last-child::before{
    height: 50%;
  }

  #{{uc_id}} .ue-button-link{
    width:fit-content;
    z-index: 100;
  }

  #{{uc_id}} .ue-card:nth-child(even) .ue-button-link {
    margin-left:auto;
  }
{% endif %}

{% if rtl == "true" %}
  #{{uc_id}} .ue-card:nth-child(even) {
    padding: 30px 0 30px 30px;
    text-align: left;
  }
  #{{uc_id}} .ue-card:nth-child(odd) {
    padding: 30px 30px 30px 0;
  }
  /* Global ::before */
  #{{uc_id}} .ue-card::before {
    content: "";
    position: absolute;
    width: 50%;
  }

  /* Setting the border of top, bottom, left */
  #{{uc_id}} .ue-card:nth-child(even)::before {
    left: 0px;
    top: -{{curved_line_thickness_nounit}}px;
    bottom: -{{curved_line_thickness_nounit}}px;
    border-width: {{curved_line_thickness_nounit}}px 0 {{curved_line_thickness_nounit}}px {{curved_line_thickness_nounit}}px;
    border-radius: 20px 0 0 20px;
  }

  /* Setting the top and bottom to "-{{curved_line_thickness_nounit}}px" because earlier it was out of a pixel in mobile devices */
  @media only screen and (max-width: 400px) {
    #{{uc_id}} .ue-card:nth-child(even)::before {
      top: -{{curved_line_thickness_nounit}}px;
      bottom: -{{curved_line_thickness_nounit}}px;
    }
  }

  /* Setting the border of top, bottom, right */
  #{{uc_id}} .ue-card:nth-child(odd)::before {
    right: 0;
    top: 0;
    bottom: 0;
    border-width: {{curved_line_thickness_nounit}}px {{curved_line_thickness_nounit}}px {{curved_line_thickness_nounit}}px 0;
    border-radius: 0 20px 20px 0;
  }

  /* Removing the border if it is the first card */
  #{{uc_id}} .ue-card:first-child::before {
    border-top: 0;
    border-top-right-radius: 0;
  }

  /* Removing the border if it is the last card  and it's odd */
  #{{uc_id}} .ue-card:last-child:nth-child(even)::before {
    border-bottom: 0;
    border-bottom-right-radius: 0;
  }

  /* Removing the border if it is the last card  and it's even */
  #{{uc_id}} .ue-card:last-child:nth-child(odd)::before {
    border-bottom: 0;
    border-bottom-left-radius: 0;
  }

  /* Information about the timeline */
  #{{uc_id}} .ue-info {
    display: flex;
    border-radius: 10px;
    padding: 10px;
    width: 100%;
  }

  /* Title of the card */
  #{{uc_id}} .ue-title {
    position: relative;
  }

  /* Timeline dot  */

  /* text right if the card is even  */
  #{{uc_id}} .ue-card:nth-child(odd) {
    text-align: right;
  }

  #{{uc_id}} .ue-card:nth-child(odd) .ue-item-image{
    margin-left: auto;
  }

  #{{uc_id}} .ue-card:nth-child(odd) .ue-info{
    padding-right: 20px;
    margin-left: auto;
  }

  #{{uc_id}} .ue-card:nth-child(even) .ue-info{
    padding-left: 20px;
  }

  /* setting dot to the left if the card is odd */
  #{{uc_id}} .ue-card:nth-child(even) > .ue-info > .ue-title::before {
    left: -45px;
  }

  #{{uc_id}} .ue-card:nth-child(odd) > .ue-slno{
    right: 0%;
    left: auto;
    transform: translate(50%, -50%);
    margin-right:calc({{curved_line_thickness_nounit}}px/2);;
  }

  #{{uc_id}} .ue-card:nth-child(even) > .ue-slno{
    margin-left:calc({{curved_line_thickness_nounit}}px/2);;
  }

  #{{uc_id}} .ue-card:nth-child(1)::before{
    height: 50%;
    top: auto;
  }

  #{{uc_id}} .ue-card:last-child::before{
    height: 50%;
  }

  #{{uc_id}} .ue-button-link{
    width:fit-content;
    z-index: 100;
  }

  #{{uc_id}} .ue-card:nth-child(odd) .ue-button-link {
    margin-left:auto;
  }
{% endif %}