<?php
/**
 * Slim Framework (https://slimframework.com)
 *
 * @license https://github.com/slimphp/Slim/blob/3.x/LICENSE.md (MIT License)
 */

namespace Slim\Exception;

use AmeliaVendor\Psr\Http\Message\ResponseInterface;
use AmeliaVendor\Psr\Http\Message\ServerRequestInterface;

class MethodNotAllowedException extends SlimException
{
    /**
     * @var string[]
     */
    protected $allowedMethods;

    /**
     * @param ServerRequestInterface $request
     * @param ResponseInterface      $response
     * @param string[]               $allowedMethods
     */
    public function __construct(ServerRequestInterface $request, ResponseInterface $response, array $allowedMethods)
    {
        parent::__construct($request, $response);
        $this->allowedMethods = $allowedMethods;
    }

    /**
     * @return string[]
     */
    public function getAllowedMethods()
    {
        return $this->allowedMethods;
    }
}
