<?php

namespace AmeliaVendor\Stripe\Util;

class ObjectTypes
{
    /**
     * @var array Mapping from object types to resource classes
     */
    const mapping
        = [
            \AmeliaVendor\Stripe\Collection::OBJECT_NAME => \AmeliaVendor\Stripe\Collection::class,
            \AmeliaVendor\Stripe\Issuing\CardDetails::OBJECT_NAME => \AmeliaVendor\Stripe\Issuing\CardDetails::class,
            \AmeliaVendor\Stripe\SearchResult::OBJECT_NAME => \AmeliaVendor\Stripe\SearchResult::class,
            \AmeliaVendor\Stripe\File::OBJECT_NAME_ALT => \AmeliaVendor\Stripe\File::class,
            // object classes: The beginning of the section generated from our OpenAPI spec
            \AmeliaVendor\Stripe\Account::OBJECT_NAME => \AmeliaVendor\Stripe\Account::class,
            \AmeliaVendor\Stripe\AccountLink::OBJECT_NAME => \AmeliaVendor\Stripe\AccountLink::class,
            \AmeliaVendor\Stripe\AccountSession::OBJECT_NAME => \AmeliaVendor\Stripe\AccountSession::class,
            \AmeliaVendor\Stripe\ApplePayDomain::OBJECT_NAME => \AmeliaVendor\Stripe\ApplePayDomain::class,
            \AmeliaVendor\Stripe\Application::OBJECT_NAME => \AmeliaVendor\Stripe\Application::class,
            \AmeliaVendor\Stripe\ApplicationFee::OBJECT_NAME => \AmeliaVendor\Stripe\ApplicationFee::class,
            \AmeliaVendor\Stripe\ApplicationFeeRefund::OBJECT_NAME => \AmeliaVendor\Stripe\ApplicationFeeRefund::class,
            \AmeliaVendor\Stripe\Apps\Secret::OBJECT_NAME => \AmeliaVendor\Stripe\Apps\Secret::class,
            \AmeliaVendor\Stripe\Balance::OBJECT_NAME => \AmeliaVendor\Stripe\Balance::class,
            \AmeliaVendor\Stripe\BalanceTransaction::OBJECT_NAME => \AmeliaVendor\Stripe\BalanceTransaction::class,
            \AmeliaVendor\Stripe\BankAccount::OBJECT_NAME => \AmeliaVendor\Stripe\BankAccount::class,
            \AmeliaVendor\Stripe\Billing\Alert::OBJECT_NAME => \AmeliaVendor\Stripe\Billing\Alert::class,
            \AmeliaVendor\Stripe\Billing\AlertTriggered::OBJECT_NAME => \AmeliaVendor\Stripe\Billing\AlertTriggered::class,
            \AmeliaVendor\Stripe\Billing\CreditBalanceSummary::OBJECT_NAME => \AmeliaVendor\Stripe\Billing\CreditBalanceSummary::class,
            \AmeliaVendor\Stripe\Billing\CreditBalanceTransaction::OBJECT_NAME => \AmeliaVendor\Stripe\Billing\CreditBalanceTransaction::class,
            \AmeliaVendor\Stripe\Billing\CreditGrant::OBJECT_NAME => \AmeliaVendor\Stripe\Billing\CreditGrant::class,
            \AmeliaVendor\Stripe\Billing\Meter::OBJECT_NAME => \AmeliaVendor\Stripe\Billing\Meter::class,
            \AmeliaVendor\Stripe\Billing\MeterEvent::OBJECT_NAME => \AmeliaVendor\Stripe\Billing\MeterEvent::class,
            \AmeliaVendor\Stripe\Billing\MeterEventAdjustment::OBJECT_NAME => \AmeliaVendor\Stripe\Billing\MeterEventAdjustment::class,
            \AmeliaVendor\Stripe\Billing\MeterEventSummary::OBJECT_NAME => \AmeliaVendor\Stripe\Billing\MeterEventSummary::class,
            \AmeliaVendor\Stripe\BillingPortal\Configuration::OBJECT_NAME => \AmeliaVendor\Stripe\BillingPortal\Configuration::class,
            \AmeliaVendor\Stripe\BillingPortal\Session::OBJECT_NAME => \AmeliaVendor\Stripe\BillingPortal\Session::class,
            \AmeliaVendor\Stripe\Capability::OBJECT_NAME => \AmeliaVendor\Stripe\Capability::class,
            \AmeliaVendor\Stripe\Card::OBJECT_NAME => \AmeliaVendor\Stripe\Card::class,
            \AmeliaVendor\Stripe\CashBalance::OBJECT_NAME => \AmeliaVendor\Stripe\CashBalance::class,
            \AmeliaVendor\Stripe\Charge::OBJECT_NAME => \AmeliaVendor\Stripe\Charge::class,
            \AmeliaVendor\Stripe\Checkout\Session::OBJECT_NAME => \AmeliaVendor\Stripe\Checkout\Session::class,
            \AmeliaVendor\Stripe\Climate\Order::OBJECT_NAME => \AmeliaVendor\Stripe\Climate\Order::class,
            \AmeliaVendor\Stripe\Climate\Product::OBJECT_NAME => \AmeliaVendor\Stripe\Climate\Product::class,
            \AmeliaVendor\Stripe\Climate\Supplier::OBJECT_NAME => \AmeliaVendor\Stripe\Climate\Supplier::class,
            \AmeliaVendor\Stripe\ConfirmationToken::OBJECT_NAME => \AmeliaVendor\Stripe\ConfirmationToken::class,
            \AmeliaVendor\Stripe\ConnectCollectionTransfer::OBJECT_NAME => \AmeliaVendor\Stripe\ConnectCollectionTransfer::class,
            \AmeliaVendor\Stripe\CountrySpec::OBJECT_NAME => \AmeliaVendor\Stripe\CountrySpec::class,
            \AmeliaVendor\Stripe\Coupon::OBJECT_NAME => \AmeliaVendor\Stripe\Coupon::class,
            \AmeliaVendor\Stripe\CreditNote::OBJECT_NAME => \AmeliaVendor\Stripe\CreditNote::class,
            \AmeliaVendor\Stripe\CreditNoteLineItem::OBJECT_NAME => \AmeliaVendor\Stripe\CreditNoteLineItem::class,
            \AmeliaVendor\Stripe\Customer::OBJECT_NAME => \AmeliaVendor\Stripe\Customer::class,
            \AmeliaVendor\Stripe\CustomerBalanceTransaction::OBJECT_NAME => \AmeliaVendor\Stripe\CustomerBalanceTransaction::class,
            \AmeliaVendor\Stripe\CustomerCashBalanceTransaction::OBJECT_NAME => \AmeliaVendor\Stripe\CustomerCashBalanceTransaction::class,
            \AmeliaVendor\Stripe\CustomerSession::OBJECT_NAME => \AmeliaVendor\Stripe\CustomerSession::class,
            \AmeliaVendor\Stripe\Discount::OBJECT_NAME => \AmeliaVendor\Stripe\Discount::class,
            \AmeliaVendor\Stripe\Dispute::OBJECT_NAME => \AmeliaVendor\Stripe\Dispute::class,
            \AmeliaVendor\Stripe\Entitlements\ActiveEntitlement::OBJECT_NAME => \AmeliaVendor\Stripe\Entitlements\ActiveEntitlement::class,
            \AmeliaVendor\Stripe\Entitlements\ActiveEntitlementSummary::OBJECT_NAME => \AmeliaVendor\Stripe\Entitlements\ActiveEntitlementSummary::class,
            \AmeliaVendor\Stripe\Entitlements\Feature::OBJECT_NAME => \AmeliaVendor\Stripe\Entitlements\Feature::class,
            \AmeliaVendor\Stripe\EphemeralKey::OBJECT_NAME => \AmeliaVendor\Stripe\EphemeralKey::class,
            \AmeliaVendor\Stripe\Event::OBJECT_NAME => \AmeliaVendor\Stripe\Event::class,
            \AmeliaVendor\Stripe\ExchangeRate::OBJECT_NAME => \AmeliaVendor\Stripe\ExchangeRate::class,
            \AmeliaVendor\Stripe\File::OBJECT_NAME => \AmeliaVendor\Stripe\File::class,
            \AmeliaVendor\Stripe\FileLink::OBJECT_NAME => \AmeliaVendor\Stripe\FileLink::class,
            \AmeliaVendor\Stripe\FinancialConnections\Account::OBJECT_NAME => \AmeliaVendor\Stripe\FinancialConnections\Account::class,
            \AmeliaVendor\Stripe\FinancialConnections\AccountOwner::OBJECT_NAME => \AmeliaVendor\Stripe\FinancialConnections\AccountOwner::class,
            \AmeliaVendor\Stripe\FinancialConnections\AccountOwnership::OBJECT_NAME => \AmeliaVendor\Stripe\FinancialConnections\AccountOwnership::class,
            \AmeliaVendor\Stripe\FinancialConnections\Session::OBJECT_NAME => \AmeliaVendor\Stripe\FinancialConnections\Session::class,
            \AmeliaVendor\Stripe\FinancialConnections\Transaction::OBJECT_NAME => \AmeliaVendor\Stripe\FinancialConnections\Transaction::class,
            \AmeliaVendor\Stripe\Forwarding\Request::OBJECT_NAME => \AmeliaVendor\Stripe\Forwarding\Request::class,
            \AmeliaVendor\Stripe\FundingInstructions::OBJECT_NAME => \AmeliaVendor\Stripe\FundingInstructions::class,
            \AmeliaVendor\Stripe\Identity\VerificationReport::OBJECT_NAME => \AmeliaVendor\Stripe\Identity\VerificationReport::class,
            \AmeliaVendor\Stripe\Identity\VerificationSession::OBJECT_NAME => \AmeliaVendor\Stripe\Identity\VerificationSession::class,
            \AmeliaVendor\Stripe\Invoice::OBJECT_NAME => \AmeliaVendor\Stripe\Invoice::class,
            \AmeliaVendor\Stripe\InvoiceItem::OBJECT_NAME => \AmeliaVendor\Stripe\InvoiceItem::class,
            \AmeliaVendor\Stripe\InvoiceLineItem::OBJECT_NAME => \AmeliaVendor\Stripe\InvoiceLineItem::class,
            \AmeliaVendor\Stripe\InvoicePayment::OBJECT_NAME => \AmeliaVendor\Stripe\InvoicePayment::class,
            \AmeliaVendor\Stripe\InvoiceRenderingTemplate::OBJECT_NAME => \AmeliaVendor\Stripe\InvoiceRenderingTemplate::class,
            \AmeliaVendor\Stripe\Issuing\Authorization::OBJECT_NAME => \AmeliaVendor\Stripe\Issuing\Authorization::class,
            \AmeliaVendor\Stripe\Issuing\Card::OBJECT_NAME => \AmeliaVendor\Stripe\Issuing\Card::class,
            \AmeliaVendor\Stripe\Issuing\Cardholder::OBJECT_NAME => \AmeliaVendor\Stripe\Issuing\Cardholder::class,
            \AmeliaVendor\Stripe\Issuing\Dispute::OBJECT_NAME => \AmeliaVendor\Stripe\Issuing\Dispute::class,
            \AmeliaVendor\Stripe\Issuing\PersonalizationDesign::OBJECT_NAME => \AmeliaVendor\Stripe\Issuing\PersonalizationDesign::class,
            \AmeliaVendor\Stripe\Issuing\PhysicalBundle::OBJECT_NAME => \AmeliaVendor\Stripe\Issuing\PhysicalBundle::class,
            \AmeliaVendor\Stripe\Issuing\Token::OBJECT_NAME => \AmeliaVendor\Stripe\Issuing\Token::class,
            \AmeliaVendor\Stripe\Issuing\Transaction::OBJECT_NAME => \AmeliaVendor\Stripe\Issuing\Transaction::class,
            \AmeliaVendor\Stripe\LineItem::OBJECT_NAME => \AmeliaVendor\Stripe\LineItem::class,
            \AmeliaVendor\Stripe\LoginLink::OBJECT_NAME => \AmeliaVendor\Stripe\LoginLink::class,
            \AmeliaVendor\Stripe\Mandate::OBJECT_NAME => \AmeliaVendor\Stripe\Mandate::class,
            \AmeliaVendor\Stripe\PaymentIntent::OBJECT_NAME => \AmeliaVendor\Stripe\PaymentIntent::class,
            \AmeliaVendor\Stripe\PaymentLink::OBJECT_NAME => \AmeliaVendor\Stripe\PaymentLink::class,
            \AmeliaVendor\Stripe\PaymentMethod::OBJECT_NAME => \AmeliaVendor\Stripe\PaymentMethod::class,
            \AmeliaVendor\Stripe\PaymentMethodConfiguration::OBJECT_NAME => \AmeliaVendor\Stripe\PaymentMethodConfiguration::class,
            \AmeliaVendor\Stripe\PaymentMethodDomain::OBJECT_NAME => \AmeliaVendor\Stripe\PaymentMethodDomain::class,
            \AmeliaVendor\Stripe\Payout::OBJECT_NAME => \AmeliaVendor\Stripe\Payout::class,
            \AmeliaVendor\Stripe\Person::OBJECT_NAME => \AmeliaVendor\Stripe\Person::class,
            \AmeliaVendor\Stripe\Plan::OBJECT_NAME => \AmeliaVendor\Stripe\Plan::class,
            \AmeliaVendor\Stripe\Price::OBJECT_NAME => \AmeliaVendor\Stripe\Price::class,
            \AmeliaVendor\Stripe\Product::OBJECT_NAME => \AmeliaVendor\Stripe\Product::class,
            \AmeliaVendor\Stripe\ProductFeature::OBJECT_NAME => \AmeliaVendor\Stripe\ProductFeature::class,
            \AmeliaVendor\Stripe\PromotionCode::OBJECT_NAME => \AmeliaVendor\Stripe\PromotionCode::class,
            \AmeliaVendor\Stripe\Quote::OBJECT_NAME => \AmeliaVendor\Stripe\Quote::class,
            \AmeliaVendor\Stripe\Radar\EarlyFraudWarning::OBJECT_NAME => \AmeliaVendor\Stripe\Radar\EarlyFraudWarning::class,
            \AmeliaVendor\Stripe\Radar\ValueList::OBJECT_NAME => \AmeliaVendor\Stripe\Radar\ValueList::class,
            \AmeliaVendor\Stripe\Radar\ValueListItem::OBJECT_NAME => \AmeliaVendor\Stripe\Radar\ValueListItem::class,
            \AmeliaVendor\Stripe\Refund::OBJECT_NAME => \AmeliaVendor\Stripe\Refund::class,
            \AmeliaVendor\Stripe\Reporting\ReportRun::OBJECT_NAME => \AmeliaVendor\Stripe\Reporting\ReportRun::class,
            \AmeliaVendor\Stripe\Reporting\ReportType::OBJECT_NAME => \AmeliaVendor\Stripe\Reporting\ReportType::class,
            \AmeliaVendor\Stripe\ReserveTransaction::OBJECT_NAME => \AmeliaVendor\Stripe\ReserveTransaction::class,
            \AmeliaVendor\Stripe\Review::OBJECT_NAME => \AmeliaVendor\Stripe\Review::class,
            \AmeliaVendor\Stripe\SetupAttempt::OBJECT_NAME => \AmeliaVendor\Stripe\SetupAttempt::class,
            \AmeliaVendor\Stripe\SetupIntent::OBJECT_NAME => \AmeliaVendor\Stripe\SetupIntent::class,
            \AmeliaVendor\Stripe\ShippingRate::OBJECT_NAME => \AmeliaVendor\Stripe\ShippingRate::class,
            \AmeliaVendor\Stripe\Sigma\ScheduledQueryRun::OBJECT_NAME => \AmeliaVendor\Stripe\Sigma\ScheduledQueryRun::class,
            \AmeliaVendor\Stripe\Source::OBJECT_NAME => \AmeliaVendor\Stripe\Source::class,
            \AmeliaVendor\Stripe\SourceMandateNotification::OBJECT_NAME => \AmeliaVendor\Stripe\SourceMandateNotification::class,
            \AmeliaVendor\Stripe\SourceTransaction::OBJECT_NAME => \AmeliaVendor\Stripe\SourceTransaction::class,
            \AmeliaVendor\Stripe\Subscription::OBJECT_NAME => \AmeliaVendor\Stripe\Subscription::class,
            \AmeliaVendor\Stripe\SubscriptionItem::OBJECT_NAME => \AmeliaVendor\Stripe\SubscriptionItem::class,
            \AmeliaVendor\Stripe\SubscriptionSchedule::OBJECT_NAME => \AmeliaVendor\Stripe\SubscriptionSchedule::class,
            \AmeliaVendor\Stripe\Tax\Calculation::OBJECT_NAME => \AmeliaVendor\Stripe\Tax\Calculation::class,
            \AmeliaVendor\Stripe\Tax\CalculationLineItem::OBJECT_NAME => \AmeliaVendor\Stripe\Tax\CalculationLineItem::class,
            \AmeliaVendor\Stripe\Tax\Registration::OBJECT_NAME => \AmeliaVendor\Stripe\Tax\Registration::class,
            \AmeliaVendor\Stripe\Tax\Settings::OBJECT_NAME => \AmeliaVendor\Stripe\Tax\Settings::class,
            \AmeliaVendor\Stripe\Tax\Transaction::OBJECT_NAME => \AmeliaVendor\Stripe\Tax\Transaction::class,
            \AmeliaVendor\Stripe\Tax\TransactionLineItem::OBJECT_NAME => \AmeliaVendor\Stripe\Tax\TransactionLineItem::class,
            \AmeliaVendor\Stripe\TaxCode::OBJECT_NAME => \AmeliaVendor\Stripe\TaxCode::class,
            \AmeliaVendor\Stripe\TaxDeductedAtSource::OBJECT_NAME => \AmeliaVendor\Stripe\TaxDeductedAtSource::class,
            \AmeliaVendor\Stripe\TaxId::OBJECT_NAME => \AmeliaVendor\Stripe\TaxId::class,
            \AmeliaVendor\Stripe\TaxRate::OBJECT_NAME => \AmeliaVendor\Stripe\TaxRate::class,
            \AmeliaVendor\Stripe\Terminal\Configuration::OBJECT_NAME => \AmeliaVendor\Stripe\Terminal\Configuration::class,
            \AmeliaVendor\Stripe\Terminal\ConnectionToken::OBJECT_NAME => \AmeliaVendor\Stripe\Terminal\ConnectionToken::class,
            \AmeliaVendor\Stripe\Terminal\Location::OBJECT_NAME => \AmeliaVendor\Stripe\Terminal\Location::class,
            \AmeliaVendor\Stripe\Terminal\Reader::OBJECT_NAME => \AmeliaVendor\Stripe\Terminal\Reader::class,
            \AmeliaVendor\Stripe\TestHelpers\TestClock::OBJECT_NAME => \AmeliaVendor\Stripe\TestHelpers\TestClock::class,
            \AmeliaVendor\Stripe\Token::OBJECT_NAME => \AmeliaVendor\Stripe\Token::class,
            \AmeliaVendor\Stripe\Topup::OBJECT_NAME => \AmeliaVendor\Stripe\Topup::class,
            \AmeliaVendor\Stripe\Transfer::OBJECT_NAME => \AmeliaVendor\Stripe\Transfer::class,
            \AmeliaVendor\Stripe\TransferReversal::OBJECT_NAME => \AmeliaVendor\Stripe\TransferReversal::class,
            \AmeliaVendor\Stripe\Treasury\CreditReversal::OBJECT_NAME => \AmeliaVendor\Stripe\Treasury\CreditReversal::class,
            \AmeliaVendor\Stripe\Treasury\DebitReversal::OBJECT_NAME => \AmeliaVendor\Stripe\Treasury\DebitReversal::class,
            \AmeliaVendor\Stripe\Treasury\FinancialAccount::OBJECT_NAME => \AmeliaVendor\Stripe\Treasury\FinancialAccount::class,
            \AmeliaVendor\Stripe\Treasury\FinancialAccountFeatures::OBJECT_NAME => \AmeliaVendor\Stripe\Treasury\FinancialAccountFeatures::class,
            \AmeliaVendor\Stripe\Treasury\InboundTransfer::OBJECT_NAME => \AmeliaVendor\Stripe\Treasury\InboundTransfer::class,
            \AmeliaVendor\Stripe\Treasury\OutboundPayment::OBJECT_NAME => \AmeliaVendor\Stripe\Treasury\OutboundPayment::class,
            \AmeliaVendor\Stripe\Treasury\OutboundTransfer::OBJECT_NAME => \AmeliaVendor\Stripe\Treasury\OutboundTransfer::class,
            \AmeliaVendor\Stripe\Treasury\ReceivedCredit::OBJECT_NAME => \AmeliaVendor\Stripe\Treasury\ReceivedCredit::class,
            \AmeliaVendor\Stripe\Treasury\ReceivedDebit::OBJECT_NAME => \AmeliaVendor\Stripe\Treasury\ReceivedDebit::class,
            \AmeliaVendor\Stripe\Treasury\Transaction::OBJECT_NAME => \AmeliaVendor\Stripe\Treasury\Transaction::class,
            \AmeliaVendor\Stripe\Treasury\TransactionEntry::OBJECT_NAME => \AmeliaVendor\Stripe\Treasury\TransactionEntry::class,
            \AmeliaVendor\Stripe\WebhookEndpoint::OBJECT_NAME => \AmeliaVendor\Stripe\WebhookEndpoint::class,
            // object classes: The end of the section generated from our OpenAPI spec
        ];

    /**
     * @var array Mapping from v2 object types to resource classes
     */
    const v2Mapping = [
        // v2 object classes: The beginning of the section generated from our OpenAPI spec
        \AmeliaVendor\Stripe\V2\Billing\MeterEvent::OBJECT_NAME => \AmeliaVendor\Stripe\V2\Billing\MeterEvent::class,
        \AmeliaVendor\Stripe\V2\Billing\MeterEventAdjustment::OBJECT_NAME => \AmeliaVendor\Stripe\V2\Billing\MeterEventAdjustment::class,
        \AmeliaVendor\Stripe\V2\Billing\MeterEventSession::OBJECT_NAME => \AmeliaVendor\Stripe\V2\Billing\MeterEventSession::class,
        \AmeliaVendor\Stripe\V2\Event::OBJECT_NAME => \AmeliaVendor\Stripe\V2\Event::class,
        \AmeliaVendor\Stripe\V2\EventDestination::OBJECT_NAME => \AmeliaVendor\Stripe\V2\EventDestination::class,
        // v2 object classes: The end of the section generated from our OpenAPI spec
    ];
}
