<?php
function mon_theme_enqueue_styles() {
    wp_enqueue_style('parent-style', get_template_directory_uri() . '/style.css');
    wp_enqueue_style('child-style', get_stylesheet_directory_uri() . '/style.css', array('parent-style'));
}
add_action('wp_enqueue_scripts', 'mon_theme_enqueue_styles');


/**
 * CPT + taxonomies Ateliers 
 */

add_action( 'init', 'bds_register_cpt_ateliers' );
function bds_register_cpt_ateliers() {

	// === CPT: Ateliers ===
	$labels = array(
		'name'                  => 'Ateliers',
		'singular_name'         => 'Atelier',
		'menu_name'             => 'Ateliers',
		'name_admin_bar'        => 'Atelier',
		'add_new'               => 'Ajouter',
		'add_new_item'          => 'Ajouter un atelier',
		'new_item'              => 'Nouvel atelier',
		'edit_item'             => 'Modifier l’atelier',
		'view_item'             => 'Voir l’atelier',
		'all_items'             => 'Tous les ateliers',
		'search_items'          => 'Rechercher des ateliers',
		'not_found'             => 'Aucun atelier trouvé.',
		'not_found_in_trash'    => 'Aucun atelier dans la corbeille.',
	);

	$args = array(
		'label'               => 'Ateliers',
		'labels'              => $labels,
		'public'              => true,
		'show_ui'             => true,
		'show_in_menu'        => true,
		'show_in_rest'        => true,
		'menu_position'       => 20,
		'menu_icon'           => 'dashicons-smiley',
		'supports'            => array( 'title', 'editor', 'thumbnail', 'excerpt', 'revisions', 'custom-fields' ),
		'has_archive'         => true,
		'rewrite'             => array( 'slug' => 'ateliers', 'with_front' => false ),
		'publicly_queryable'  => true,
	);
	register_post_type( 'atelier', $args );

	// === Taxonomie hiérarchique : Types d’atelier ===
	$type_labels = array(
		'name'              => 'Types d’atelier',
		'singular_name'     => 'Type d’atelier',
		'search_items'      => 'Rechercher des types',
		'all_items'         => 'Tous les types',
		'parent_item'       => 'Type parent',
		'edit_item'         => 'Modifier le type',
		'update_item'       => 'Mettre à jour le type',
		'add_new_item'      => 'Ajouter un nouveau type',
		'new_item_name'     => 'Nouveau type',
		'menu_name'         => 'Types d’atelier',
	);
	register_taxonomy(
		'type-atelier',
		array( 'atelier' ),
		array(
			'labels'            => $type_labels,
			'hierarchical'      => true,
			'show_ui'           => true,
			'show_admin_column' => true,
			'show_in_rest'      => true,
			'rewrite'           => array( 'slug' => 'type-atelier', 'with_front' => false ),
		)
	);

	// === Taxonomie non hiérarchique : Mots-clés d’atelier ===
	$tag_labels = array(
		'name'                       => 'Mots-clés d’atelier',
		'singular_name'              => 'Mot-clé d’atelier',
		'search_items'               => 'Rechercher des mots-clés',
		'all_items'                  => 'Tous les mots-clés',
		'edit_item'                  => 'Modifier le mot-clé',
		'update_item'                => 'Mettre à jour le mot-clé',
		'add_new_item'               => 'Ajouter un mot-clé',
		'new_item_name'              => 'Nouveau mot-clé',
		'separate_items_with_commas' => 'Séparer avec des virgules',
		'menu_name'                  => 'Mots-clés d’atelier',
	);
	register_taxonomy(
		'mot-atelier',
		array( 'atelier' ),
		array(
			'labels'            => $tag_labels,
			'hierarchical'      => false,
			'show_ui'           => true,
			'show_admin_column' => true,
			'show_in_rest'      => true,
			'rewrite'           => array( 'slug' => 'mot-atelier', 'with_front' => false ),
		)
	);
}

/**
 * CPT + taxonomies Jobs 
 */

add_action( 'init', 'bds_register_cpt_jobs' );
function bds_register_cpt_jobs() {

	// === CPT: Jobs ===
	$labels = array(
	'name'                  => 'Nous rejoindre',
	'singular_name'         => 'Nous rejoindre',
	'menu_name'             => 'Job',
	'name_admin_bar'        => 'Job',
	'add_new'               => 'Ajouter',
	'add_new_item'          => 'Ajouter un job',
	'new_item'              => 'Nouveau job',
	'edit_item'             => 'Modifier le job',
	'view_item'             => 'Voir le job',
	'all_items'             => 'Tous les jobs',
	'search_items'          => 'Rechercher des jobs',
	'not_found'             => 'Aucun job trouvé.',
	'not_found_in_trash'    => 'Aucun job dans la corbeille.',
	'archives'              => 'Nous rejoindre', // 🔥 utilisé pour les breadcrumbs
);

	$args = array(
	'label'               => 'Jobs',
	'labels'              => $labels,
	'public'              => true,
	'show_ui'             => true,
	'show_in_menu'        => true,
	'show_in_rest'        => true,
	'menu_position'       => 20,
	'menu_icon'           => 'dashicons-businessman',
	'supports'            => array( 'title', 'editor', 'thumbnail', 'excerpt', 'revisions', 'custom-fields' ),
	'has_archive' => 'nous-rejoindre',
	'rewrite'     => array( 'slug' => 'nous-rejoindre', 'with_front' => false ),

	'publicly_queryable'  => true,
);

	register_post_type( 'job', $args );

	// === Taxonomie hiérarchique : Catégories de job ===
	$type_labels = array(
		'name'              => 'Catégories de jobs',
		'singular_name'     => 'Catégorie de job',
		'search_items'      => 'Rechercher des catégories',
		'all_items'         => 'Toutes les catégories',
		'parent_item'       => 'Catégorie parente',
		'edit_item'         => 'Modifier la catégorie',
		'update_item'       => 'Mettre à jour la catégorie',
		'add_new_item'      => 'Ajouter une nouvelle catégorie',
		'new_item_name'     => 'Nouvelle catégorie',
		'menu_name'         => 'Catégories de jobs',
	);
	register_taxonomy(
		'categorie-job',
		array( 'job' ),
		array(
			'labels'            => $type_labels,
			'hierarchical'      => true,
			'show_ui'           => true,
			'show_admin_column' => true,
			'show_in_rest'      => true,
			'rewrite'           => array( 'slug' => 'categorie-job', 'with_front' => false ),
		)
	);

	// === Taxonomie non hiérarchique : Mots-clés de job ===
	$tag_labels = array(
		'name'                       => 'Mots-clés de job',
		'singular_name'              => 'Mot-clé de job',
		'search_items'               => 'Rechercher des mots-clés',
		'all_items'                  => 'Tous les mots-clés',
		'edit_item'                  => 'Modifier le mot-clé',
		'update_item'                => 'Mettre à jour le mot-clé',
		'add_new_item'               => 'Ajouter un mot-clé',
		'new_item_name'              => 'Nouveau mot-clé',
		'separate_items_with_commas' => 'Séparer avec des virgules',
		'menu_name'                  => 'Mots-clés de job',
	);
	register_taxonomy(
		'mot-job',
		array( 'job' ),
		array(
			'labels'            => $tag_labels,
			'hierarchical'      => false,
			'show_ui'           => true,
			'show_admin_column' => true,
			'show_in_rest'      => true,
			'rewrite'           => array( 'slug' => 'mot-job', 'with_front' => false ),
		)
	);
}

// Rendre DearFlip visible dans Elementor
add_action('init', function() {
    $args = get_post_type_object('dflip_books');
    if ($args) {
        $args->show_in_rest = true;
        $args->public = true;
        $args->publicly_queryable = true;
    }
});

/*AJOUT JS*/
function bd_enqueue_custom_script() {
    wp_enqueue_script(
        'bd-custom-script',
        get_stylesheet_directory_uri() . '/main.js',
        array(), 
        null,
        true 
    );
}
add_action('wp_enqueue_scripts', 'bd_enqueue_custom_script');

//FLIP BOOK RETIRER LES 4 DERNIERS REMUE MENINGES

function dflip_all_except_last_three() {

    $books = get_posts([
        'post_type'      => 'dflip',
        'posts_per_page' => -1,
        'orderby'        => 'date',
        'order'          => 'DESC',
    ]);

    // Retirer les 4 derniers livres
    $books = array_slice($books, 4);

    // Récupérer les IDs
    $ids = wp_list_pluck($books, 'ID');

    if (empty($ids)) {
        return '';
    }

    return do_shortcode('[dflip books="' . implode(',', $ids) . '" limit="-1"]');
}
add_shortcode('dflip_sans_4_derniers', 'dflip_all_except_last_three');

// Forcer le statut de paiement Amelia en "En attente" pour WooCommerce
add_filter('amelia_before_payment_added_filter', function ($payment) {
    // Si c'est un paiement WooCommerce, forcer en "pending"
    if (isset($payment['gateway']) && $payment['gateway'] === 'wooCommerce') {
        $payment['status'] = 'pending';
    }
    return $payment;
}, 10, 1);

// Forcer le statut de réservation en "pending" à la création
add_filter('amelia_before_booking_added_filter', function ($booking) {
    $booking['status'] = 'pending';
    return $booking;
}, 10, 1);

// Empêcher la mise à jour automatique à "paid" lors de la création de commande WooCommerce
add_action('woocommerce_checkout_order_processed', function($order_id) {
    global $wpdb;
    
    // Récupérer les paiements Amelia liés à cette commande
    $payments = $wpdb->get_results($wpdb->prepare(
        "SELECT * FROM {$wpdb->prefix}amelia_payments WHERE wcOrderId = %d",
        $order_id
    ));
    
    foreach ($payments as $payment) {
        // Forcer le statut à "pending"
        $wpdb->update(
            $wpdb->prefix . 'amelia_payments',
            array('status' => 'pending'),
            array('id' => $payment->id)
        );
    }
}, 10, 1);

//MAILS AMELIA
add_filter('amelia_before_email_sent', function ($email, $booking) {

    if (empty($booking['id'])) {
        return $email;
    }

    global $wpdb;

    $table = $wpdb->prefix . 'amelia_customer_bookings';

    $wc_order_id = $wpdb->get_var(
        $wpdb->prepare(
            "SELECT wcOrderId FROM $table WHERE id = %d",
            $booking['id']
        )
    );

    if ($wc_order_id) {

        $order = wc_get_order($wc_order_id);

        if ($order) {
            $email['body'] = str_replace('%wc_order_number%', $order->get_order_number(), $email['body']);
            $email['body'] = str_replace('%wc_order_total%', wc_price($order->get_total()), $email['body']);
        }
    }

    return $email;

}, 10, 2);


?>



