//LIEN ANCRE OFFSET
document.querySelectorAll('a[href^="#"]').forEach(anchor => {
  anchor.addEventListener("click", function(e) {
    e.preventDefault();

    const targetID = this.getAttribute("href").substring(1);
    const target = document.getElementById(targetID);

    if (target) {
      const offset = 120; // valeur fixe en px
      const top = target.getBoundingClientRect().top + window.scrollY - offset;

      window.scrollTo({
        top,
        behavior: "smooth"
      });
    }
  });
});

function addIconToAmeliaButton(button) {
  // Ne rien faire si l'icône existe déjà
  if (button.querySelector(".elementor-button-icon")) return;

  const iconSpan = document.createElement("span");
  iconSpan.className = "elementor-button-icon";
  iconSpan.innerHTML = `
    <svg aria-hidden="true" class="e-font-icon-svg e-fas-arrow-right" viewBox="0 0 448 512" xmlns="http://www.w3.org/2000/svg">
      <path d="M190.5 66.9l22.2-22.2c9.4-9.4 24.6-9.4 33.9 0L441 239c9.4 9.4 9.4 24.6 0 33.9L246.6 467.3c-9.4 9.4-24.6 9.4-33.9 0l-22.2-22.2c-9.5-9.5-9.3-25 .4-34.3L311.4 296H24c-13.3 0-24-10.7-24-24v-32c0-13.3 10.7-24 24-24h287.4L190.9 101.2c-9.8-9.3-10-24.8-.4-34.3z"></path>
    </svg>
  `;

  const textSpan = button.querySelector(".am-button__inner");
  if (textSpan) {
    textSpan.insertAdjacentElement("afterend", iconSpan);
  }
}

function injectAmeliaButtonIcons() {
  document.querySelectorAll(".am-button").forEach(addIconToAmeliaButton);
}

// ---- MutationObserver pour détecter toute modification ----
const observer = new MutationObserver(() => {
  injectAmeliaButtonIcons();
});

// Surveille tout le body car Amelia remplace des blocs complets
observer.observe(document.body, {
  childList: true,
  subtree: true
});

// Lancement initial
injectAmeliaButtonIcons();



//Filtres ateliers depuis la page d'accueil
document.addEventListener('DOMContentLoaded', function() {
    // 1. Récupérer le paramètre 'filtre' de l'URL
    const urlParams = new URLSearchParams(window.location.search);
    const categorieSlug = urlParams.get('filtre');

    if (categorieSlug) {
        // 2. Construire le sélecteur du bouton de filtre
        // **REMPLACEZ** la partie entre parenthèses par le sélecteur réel que vous avez trouvé (ex: [data-slug="' + categorieSlug + '"] ou .filter-' + categorieSlug)
        const selecteurCible = '[data-filter="' + categorieSlug + '"]'; 
        
        // 3. Trouver l'élément et simuler le clic
        const boutonFiltre = document.querySelector(selecteurCible);

        if (boutonFiltre) {
            // Un petit délai peut être nécessaire pour s'assurer que le widget Elementor est initialisé
            setTimeout(() => {
                boutonFiltre.click();
            }, 500); // 500ms de délai
        }
    }
});


//SLIDER EVENT HOME PAGE
jQuery(document).ready(function($) {
    
    // Fonction pour initialiser le ping-pong
    function initPingPong() {
        // Trouver le slider spécifique par son ID
        const $sliderElement = $('#event-accueil');
        
        if ($sliderElement.length === 0) {
            console.log('Slider non trouvé, nouvelle tentative...');
            setTimeout(initPingPong, 500);
            return;
        }
        
        const swiperContainer = $sliderElement.find('.swiper-container, .swiper')[0];
        
        if (!swiperContainer || !swiperContainer.swiper) {
            console.log('Swiper non initialisé, nouvelle tentative...');
            setTimeout(initPingPong, 500);
            return;
        }
        
        const swiper = swiperContainer.swiper;
        const totalSlides = swiper.slides.length;
        
        let direction = 1; // 1 = avancer, -1 = reculer
        let isAutoPlaying = true;
        let autoplayInterval;
        
        console.log('Ping-Pong initialisé avec', totalSlides, 'slides');
        
        // Fonction pour gérer le changement de slide
        function autoSlide() {
            if (!isAutoPlaying) return;
            
            const currentIndex = swiper.activeIndex;
            
            console.log('Current index:', currentIndex, 'Direction:', direction);
            
            // Si on est à la dernière slide, inverser la direction
            if (currentIndex === totalSlides - 1 && direction === 1) {
                direction = -1;
                console.log('Arrivé à la fin, direction inversée');
            }
            // Si on est à la première slide, inverser la direction
            else if (currentIndex === 0 && direction === -1) {
                direction = 1;
                console.log('Retour au début, direction inversée');
            }
            
            // Aller à la slide suivante selon la direction
            if (direction === 1) {
                swiper.slideNext();
            } else {
                swiper.slidePrev();
            }
        }
        
        // Démarrer l'autoplay personnalisé (5 secondes par slide)
        function startAutoplay() {
            clearInterval(autoplayInterval);
            autoplayInterval = setInterval(autoSlide, 3000);
        }
        
        startAutoplay();
        
        // Mettre en pause au survol
        $sliderElement.on('mouseenter', function() {
            console.log('Pause');
            isAutoPlaying = false;
            clearInterval(autoplayInterval);
        });
        
        // Reprendre après le survol
        $sliderElement.on('mouseleave', function() {
            console.log('Reprise');
            isAutoPlaying = true;
            startAutoplay();
        });
        
        // Gérer les clics manuels sur les flèches ou pagination
        swiper.on('slideChange', function() {
            const currentIndex = this.activeIndex;
            
            // Détecter si c'est un changement manuel
            if (!isAutoPlaying) {
                // Ajuster la direction en fonction de la position après un clic manuel
                if (currentIndex === totalSlides - 1) {
                    direction = -1;
                } else if (currentIndex === 0) {
                    direction = 1;
                }
            }
        });
        
        // Nettoyer l'intervalle quand on quitte la page
        $(window).on('beforeunload', function() {
            clearInterval(autoplayInterval);
        });
    }
    
    // Attendre que le DOM et Elementor soient prêts
    if (typeof elementorFrontend !== 'undefined') {
        $(window).on('elementor/frontend/init', function() {
            setTimeout(initPingPong, 1000);
        });
    } else {
        // Fallback si Elementor n'est pas encore chargé
        setTimeout(initPingPong, 2000);
    }
});


// Enregistrement du formulaire d'admissions
document.addEventListener("DOMContentLoaded", function () {
    const form = document.querySelector("#admission-form");
    if (!form) return;

    const storageKey = "admission-form-data";

    // 🔄 Restaurer les données sauvegardées
    const savedData = JSON.parse(localStorage.getItem(storageKey));
    if (savedData) {
        Object.keys(savedData).forEach(name => {
            const field = form.querySelector(`[name="${name}"]`);
            if (field) {
                if (field.type === "checkbox" || field.type === "radio") {
                    field.checked = savedData[name];
                } else {
                    field.value = savedData[name];
                }
            }
        });
    }

    // 💾 Sauvegarde automatique à chaque saisie
    form.addEventListener("input", function () {
        const data = {};

        form.querySelectorAll("input, textarea, select").forEach(el => {
            if (!el.name || el.type === "password" || el.type === "file") return;

            if (el.type === "checkbox" || el.type === "radio") {
                data[el.name] = el.checked;
            } else {
                data[el.name] = el.value;
            }
        });

        localStorage.setItem(storageKey, JSON.stringify(data));
    });

    // 🧹 Nettoyer après envoi réussi
    form.addEventListener("submit", function () {
        localStorage.removeItem(storageKey);
    });
});


// Exécution après chargement du DOM
document.addEventListener("DOMContentLoaded", injectBlogReadMoreIcons);


